package Cluedo.Tools;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;

import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

import Cluedo.API.Resources;
import Cluedo.Tools.Adjacency.Node;

/**
 * @author Alex
 */
public class AdjacencyToolbar extends JPanel{
	JTextField lblText = new JTextField(7);
	JTextField typText = new JTextField(7);
	JButton resetNode = new JButton("Reset node");
	JButton removeLink = new JButton("Remove link");
	
	JList linksList = new JList(new String[]{"(none)"});
	Adjacency adjacency;
	DefaultListModel listModel = new DefaultListModel();
	
	public void updateFields() {
		Node n;
		if((n = adjacency.getSelectedNode()) != null) {
			lblText.setEditable(false);
			lblText.setText(n.ID);
			
			listModel.clear();
			for(int i =0;i<n.links.size();i++)
				listModel.add(i, ((String)n.links.get(i)));
			
			linksList.setModel(listModel);
			
		}
		
	}
	
	public AdjacencyToolbar (Adjacency adjacency) {
		this.adjacency = adjacency;
		JPanel nodePanel = makeNodePanel();  
		JPanel linksPanel =  makeLinksPanel();

		GridBagLayout grid = new GridBagLayout();
		GridBagConstraints c = new GridBagConstraints();
		setLayout(grid);		

		c.weightx=1;
		c.gridx=0;
		c.gridy=0;
		
		c.fill = GridBagConstraints.BOTH;
		grid.setConstraints(nodePanel, c);

		add(nodePanel);

		c.gridy++;
		grid.setConstraints(linksPanel, c);
		add(linksPanel);
		

	}

	/**
	 * Top of panel reviews current node
	 * 
	 * @return
	 */
	private JPanel makeNodePanel() {
		JPanel content = new JPanel();
		GridBagLayout grid = new GridBagLayout();
		GridBagConstraints c = new GridBagConstraints();
		content.setLayout(grid);		

//		content.setPreferredSize(new Dimension(150, 150));
		content.setOpaque(true);
		
		
		JLabel lblLabel = new JLabel("Label");
		JLabel typLabel = new JLabel("Type");
		
		c.insets = new Insets(0, 0, 10, 10);
		
		c.weightx=1;

		c.anchor = GridBagConstraints.WEST;
		
		c.gridx=0;
		c.gridy=0;
		grid.setConstraints(lblLabel, c);
		content.add(lblLabel);
		
		c.gridx++;
		c.fill = GridBagConstraints.HORIZONTAL;
		grid.setConstraints(lblText, c);
		content.add(lblText);

		c.fill = GridBagConstraints.NONE;	
		c.gridx=0;
		c.gridy++;
		grid.setConstraints(typLabel, c);
		content.add(typLabel);
		
		c.gridx++;
		c.fill = GridBagConstraints.BOTH;
		grid.setConstraints(typText, c);
		content.add(typText);
		
		c.fill = GridBagConstraints.NONE;

		c.gridx=0;
		c.gridy++;
		//c.weightx=2;
		c.gridwidth=2;

		grid.setConstraints(resetNode, c);
		content.add(resetNode);

/*		c.gridx=0;
		c.gridy++;
		//xc.weightx=2;
		c.weighty=2;
		JPanel panel = new JPanel();
		c.gridwidth = 2;
		panel.setOpaque(false);
		c.fill=GridBagConstraints.BOTH;
		grid.setConstraints(panel, c);
		content.add(panel);*/

		content.setBorder( BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Node"));
		return content;
	}
	
	/**
	 * @return
	 */
	private JPanel makeLinksPanel() {
		JPanel content = new JPanel();
		GridBagLayout grid = new GridBagLayout();
		GridBagConstraints c = new GridBagConstraints();
		content.setLayout(grid);		

		//content.setPreferredSize(new Dimension(150, 250));
		content.setOpaque(true);

		JScrollPane listScroll = new JScrollPane(linksList);
		//content.setPreferredSize(new Dimension(100,200));
		//listScroll.setPreferredSize(new Dimension(100,200));
		
		c.insets = new Insets(0, 0, 10, 10);
		
		c.weightx=1;

		c.anchor = GridBagConstraints.WEST;
		
		c.gridx=0;
		c.gridy=0;

		
		c.gridx++;
		c.fill = GridBagConstraints.BOTH;
		grid.setConstraints(listScroll, c);
		content.add(listScroll);
		
		c.fill = GridBagConstraints.NONE;

		c.gridx=0;
		c.gridy++;
		//c.weightx=2;
		c.gridwidth=2;

		grid.setConstraints(removeLink, c);
		content.add(removeLink);
/*
		c.gridx=0;
		c.gridy++;
		//xc.weightx=2;
		c.weighty=2;
		JPanel panel = new JPanel();
		c.gridwidth = 2;
		panel.setOpaque(false);
		c.fill=GridBagConstraints.BOTH;
		grid.setConstraints(panel, c);
		content.add(panel);
*/
		content.setBorder( BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Links"));
		return content;
	}



	public static void main(String[] args) {
		Resources.configureUI();
		JFrame frame = new JFrame();

		Adjacency a = new Adjacency();
		
		AdjacencyToolbar at = new AdjacencyToolbar(a);
		
		frame.getContentPane().setLayout(new GridLayout(0,1));
		frame.getContentPane().add(at);
		frame.pack();
		frame.setVisible(true);
		
	}
}
