/*
 * Created on Dec 17, 2004
 */
package Cluedo.Tests;

import junit.framework.TestCase;
import Cluedo.Game.*;

/**
 * @author Zubair
 */
public class TestSquare extends TestCase {
	Square A1 = new Square("A1");
	Square A2 = new Square("A2");
	Square A3 = new Square("A3");
	Square A4 = new Square("A4");
	Square B1 = new Square("B1");
	Square B4 = new Square("B4");
	Square C1 = new Square("C1");
	Square C4 = new Square("C4");
	Room Kitchen = new Room("Kitchen");
	
	Player P1 = new Player();
	Player P2 = new Player();
	
	/*
	 * @see TestCase#setUp()
	 */
	protected void setUp() throws Exception {
		super.setUp();

		P1.setName("Zubs");
		P1.setCharacter("MrsWhite");
		
		P1.setName("Shab");
		P1.setCharacter("Mustard");
		
		A1.setPiece(P1);
		A1.setPiece(P2);
		A1.addNeighbour(A2);
		A1.addNeighbour(B1);
		A2.addNeighbour(A1);
		A2.addNeighbour(A3);
		A2.addNeighbour(Kitchen);
		Kitchen.addNeighbour(A2);
		A3.addNeighbour(A2);
		A3.addNeighbour(A4);
		A4.addNeighbour(A3);
		A4.addNeighbour(B4);
		B4.addNeighbour(A4);
		B4.addNeighbour(C4);
		C4.addNeighbour(B4);
		B1.addNeighbour(A1);
		B1.addNeighbour(C1);
		C1.addNeighbour(B1);
	}

	/*
	 * @see TestCase#tearDown()
	 */
	protected void tearDown() throws Exception {
		super.tearDown();
	}

	/**
	 * Constructor for SquareTest.
	 * @param arg0
	 */
	public TestSquare(String arg0) {
		super(arg0);
	}

	public void testIsOccupied() {
		assertEquals(A1.isOccupied(), true);
	}

	public void testGetPresent() {
		assertEquals(((Player)A1.getPresent().firstElement()),P1);
	}

	public void testGetID() {
		assertEquals(A1.getID(),"A1");
	}

}
