/*
 * Created on Dec 15, 2004
 */
package Cluedo.Tests;

import Cluedo.Game.*;
import junit.framework.TestCase;

public class TestPlayer extends TestCase {

	Player playerShab = new Player();
	Player playerAlex = new Player();
	CardCollection cardPack = new CardCollection();
	Card c1 = new Card("Mrs White", "Character");
	
	
	/*
	 * @see TestCase#setUp()
	 */
	protected void setUp() throws Exception {
		super.setUp();

		playerShab.setCharacter("MrsWhite");
		playerShab.setName("Shab");
		playerAlex.setCharacter("MrsScarlett");
		playerAlex.setName("Alex");	
		
		cardPack.insertCard(c1);
	}

	/*
	 * @see TestCase#tearDown()
	 */
	protected void tearDown() throws Exception {
		super.tearDown();
	}

	/**
	 * Constructor for testPlayer.
	 * @param arg0
	 */
	public TestPlayer(String arg0) {
		super(arg0);
		
	}

	public void testPlayer() {
		//TODO Implement Player().
	}

	public void testSetCards() {
		//TODO Implement setCards().
		/* this test confirms that a CardCollection can be added to a Player
		 * and also it can be retrieved 
		 * 
		 */
		playerShab.setCards(cardPack);
		CardCollection getCollection = playerShab.getCards();
		Card name = getCollection.cardByName("Mrs White");
		assertEquals(getCollection.countCards(),1);
		assertEquals(playerShab.hasCard(c1), true);
	}

	public void testGetCards() {
		//TODO Implement getCards().
		/*
		 * see testSetCards()
		 */
		
	}

	public void testSetPosition() {
		//TODO Implement setPosition().
		/* This test confirms that a position can be set to a player
		 * and the position can be retrieved.
		 */
		playerShab.setPosition(new Room("Kitchen"));
		assertEquals(playerShab.getPosition().getID(), "Kitchen");
	}

	public void testGetPosition() {
		//TODO Implement getPosition().
	//see above.
	}

	public void testHasCard() {
		//TODO Implement hasCard().
		//see testSetCards()
	}

	public void testGiveCard() {
		//TODO Implement giveCard().
		playerShab.giveCard(new Card("Mustard", "Chracter"));
	}

	public void testClearCards() {
		//TODO Implement clearCards().
		playerShab.clearCards();
	}

	public void testSetName() {
		//TODO Implement setName().
		Player test = new Player();
		test.setName("Test");
		assertEquals("Test", test.getRealName());
	}

	public void testSetCharacter() {
		//TODO Implement setCharacter().
		Player test = new Player();
		test.setName("Test");
		test.setCharacter("Green");
		assertEquals("Green", test.getCharacter());
	}

	public void testSetMovesRemaining() {
		//TODO Implement setMovesRemaining().
		playerShab.setMovesRemaining(3);
		assertEquals(3,playerShab.getMovesRemaining());
	}

	public void testSetInteractive() {
		//TODO Implement setInteractive().
		playerShab.setInteractive(true);
		assertTrue(playerShab.isInteractive());
	}

	public void testIsInteractive() {
		//TODO Implement isInteractive().
		assertTrue(playerShab.isInteractive());
	}

	public void testGetRealName() {
		//TODO Implement getRealName().
		assertEquals("Shab", playerShab.getRealName());
	}

	public void testGetCharacter() {
		//TODO Implement getCharacter().
		assertEquals("MrsWhite", playerShab.getCharacter());
	}

	public void testGetMovesRemaining() {
		//TODO Implement getMovesRemaining().
		assertEquals(3,playerShab.getMovesRemaining());
	}

	public void testToXML() {
		//TODO Implement toXML().
	}

	public void testEndTurn() {
		//TODO Implement endTurn().
		playerShab.endTurn();
	}

	public void testGetDetectivePad() {
		//TODO Implement getDetectivePad().
		
	}

	public void testSetDetectivePad() {
		//TODO Implement setDetectivePad().
		playerShab.setDetectivePad(new DetectivePad());
	
	}

	public void testCanRoll() {
		assertTrue(playerAlex.canRoll());
		assertFalse(playerShab.canRoll());// this should be false??
		
		//TODO Implement canRoll().
	}

	public void testCanMove() {
		//TODO Implement canMove().
		assertFalse(playerAlex.canMove());
	}

	public void testCanSuggestHere() {
		//TODO Implement canSuggestHere().
	}

	public void testCanSuggest() {
		//TODO Implement canSuggest().
	}

	public void testCanEndTurn() {
		//TODO Implement canEndTurn().
		
	}

	public void testHasRolled() {
		//TODO Implement hasRolled().
		assertFalse(playerAlex.hasRolled());
	}

	public void testSetRolled() {
		//TODO Implement setRolled().
		playerShab.setRolled(false);
		assertFalse(playerShab.hasRolled());
	}

	public void testHasMoved() {
		//TODO Implement hasMoved().
		playerShab.hasMoved();
	}

	public void testSetMoved() {
		//TODO Implement setMoved().
		playerShab.setMoved(true);
		assertTrue(playerShab.hasMoved());
	}

	public void testResetMovedStatus() {
		//TODO Implement resetMovedStatus().
		playerShab.resetMovedStatus();
	}

	public void testIsSuggestionOnLastTurn() {
		//TODO Implement isSuggestionOnLastTurn().
		
	}

	public void testSetSuggestionOnLastTurn() {
		//TODO Implement setSuggestionOnLastTurn().
	}

}
