package Cluedo.Tests;
import junit.framework.TestCase;
import Cluedo.Game.*;
/*
 * Created on Dec 15, 2004

 */

/**
 * @author Zubair
 */
public class TestCardCollection extends TestCase {
	CardCollection cards = new CardCollection();
	
	/*
	 * @see TestCase#setUp()
	 */
	protected void setUp() throws Exception {
		super.setUp();
		cards.insertCard( new Card("Alex", "Suspect"));
		cards.insertCard( new Card("Zubair", "Suspect"));
		cards.insertCard( new Card("Kitchen", "Room"));
		cards.insertCard( new Card("Conservatory", "Room"));
		cards.insertCard( new Card("Dagger", "Weapon"));
		cards.insertCard( new Card("Knife", "Weapon"));

	}

	/*
	 * @see TestCase#tearDown()
	 */
	protected void tearDown() throws Exception {
		super.tearDown();
	}

	/**
	 * Constructor for CardCollectionTest.
	 * @param arg0
	 */
	public TestCardCollection(String arg0) {
		super(arg0);
	}

	public void testResetCards() {
		//cards.resetCards();
	}

	public void testCountCards() {
		assertEquals(6,cards.countCards());
	}

	public void testCardAt() {
		boolean ok = false;
		if(cards.cardAt(1).getName().equals("Zubair"))
			ok = true;
		assertEquals(ok, true);
	}
	/*
	 * Succesfully Mark a Card Eliminated
	 */
	public void testMarkCard() {
		boolean ok = false;
		cards.cardByName("Alex").eliminateCard(true);
		if(cards.cardByName("Alex").isEliminated()==true)
			ok = true;
		assertEquals(ok, true);		
	}
	/*
	 * Succesfully Mark a Card UnEliminated
	 */
	public void testUnMarkCard() {
		boolean ok = false;
		if (cards.cardByName("Alex").isEliminated()==true){
			cards.cardByName("Alex").eliminateCard(false);
			ok = true;
			assertEquals(ok, true);
		}
			
			
	}
	/*
	 * Succesfully insert a Card
	 */
	public void testInsertCard() {
		cards.insertCard(new Card("Mustart","Suspect" ));
		assertEquals(7,cards.countCards());
	}

	public void testCardByName() {
		boolean ok = false;
		if(cards.cardByName("Alex").getName().equals("Alex"))
			ok = true;
		assertEquals(ok, true);
	}

	public void testContainsCard() {
		
		
	}

	public void testGetCards() {
		cards.getCards();
	}

}
