/*
 * Created on Dec 15, 2004
 */
package Cluedo.Tests;

import junit.framework.TestCase;
import java.util.Vector;

import Cluedo.Game.*;

/**
 * @author zubair
 */
public class TestBoard extends TestCase {

	
		Board board = null;
		Player playerShab = new Player();
		Player playerAlex = new Player();
		CardCollection env = new CardCollection();
		
		
	/*
	 * @see TestCase#setUp()
	 */
	protected void setUp() throws Exception {
		super.setUp();
		board = new Board();

		playerShab.setCharacter("MrsWhite");
		playerShab.setName("Shab");
		playerAlex.setCharacter("MrsScarlett");
		playerAlex.setName("Alex");		

		board.addPlayer(playerShab);
		board.addPlayer(playerAlex);		
		
		env.insertCard(new Card("Mrs White","Character"));
		env.insertCard(new Card("Rope","Weapon"));
		env.insertCard(new Card("Kitchen","Room"));
			
	}

	/*
	 * @see TestCase#tearDown()
	 */
	protected void tearDown() throws Exception {
		super.tearDown();
	}

	/**
	 * Constructor for testBoard.
	 * @param arg0
	 */
	public TestBoard(String arg0) {
		super(arg0);
	}

	/*
	 * Class under test for void Board(int, int, int)
	 */
	public void testBoardintintint() {
		//TODO Implement Board().
	}

	/*
	 * Class under test for void Board()
	 */
	public void testBoard() {
		//TODO Implement Board().
	}

	public void testRollDice() {
		//TODO Implement rollDice().
		board.rollDice();
	}

	public void testGetGameFinished() {
		//TODO Implement getGameFinished().
		assertFalse(board.getGameFinished());
	}

	public void testSetGameFinished() {
		//TODO Implement setGameFinished().
		board.setGameFinished(true);
		assertTrue(board.getGameFinished());
	}

	public void testNextPlayer() {
		//TODO Implement nextPlayer().

		
		board.nextPlayer();
		assertEquals(board.getCurrentPlayer(),playerAlex);
		assertEquals(board.getCurrentPlayer().canRoll(), true);
		assertEquals(board.getCurrentPlayer().canMove(), true);
		assertEquals(board.getCurrentPlayer().hasRolled(), false);
		
	}

	public void testGetPlayer() {
		//TODO Implement getPlayer().
		
		assertEquals(board.getPlayer("Alex"), playerAlex);
		assertEquals(board.getPlayer("Shab"), playerShab);
		assertEquals(board.getPlayer("zubz"), null);
		
	}

	public void testCountPlayers() {
		//TODO Implement countPlayers().
		assertEquals(board.countPlayers(), 2);
	}

	public void testGetPlayers() {
		//TODO Implement getPlayers().
		Vector playerTest = new Vector();
		playerTest.add(playerShab);
		playerTest.add(playerAlex);

		
		assertEquals(board.getPlayers().elementAt(0), playerTest.elementAt(0));
		assertEquals(board.getPlayers().elementAt(1), playerTest.elementAt(1));
	}

	public void testShortestPathTo() {
		//TODO Implement shortestPathTo().
		
	}

	public void testCreateSquares() {
		//TODO Implement createSquares().
		board.createSquares(null);
		
	}

	public void testCreateBindings() {
		//TODO Implement createBindings().
	}

	public void testGetCurrentPlayer() {
		//TODO Implement getCurrentPlayer().
		assertEquals(board.getCurrentPlayer(),playerShab);
	}

	public void testAddPlayer() {
		//TODO Implement addPlayer().
		assertFalse(board.addPlayer(playerShab));
		assertEquals(board.getCurrentPlayer(),playerShab);

	}

	public void testToXML() {
		//TODO Implement toXML().
	}

	public void testGetCardPackLink() {
		//TODO Implement getCardPackLink().
		CardCollection link = board.getCardPackLink();
	}

	public void testGetCardPack() {
		//TODO Implement getCardPack().
		CardCollection pack = board.getCardPack();
	}

	public void testSetCardPack() {
		//TODO Implement setCardPack().
		board.setCardPack(new CardCollection());
	}

	public void testGetEnvelope() {
		//TODO Implement getEnvelope().
		CardCollection tmpEnv = board.getEnvelope();
		assertEquals(env, tmpEnv);
	}

	public void testSetEnvelope() {
		//TODO Implement setEnvelope().
				
				board.setEnvelope(env);
				
				assertEquals(board.getEnvelope(),env);
	}

}
