package Cluedo.Game;
import java.util.Vector;

/**
 * Same behaviour as Square, players are placed here at the beginning of
 * a game.<p>
 *  
 * @author Alex
 *
 */
public class StartingSquare  extends Square {
	BoardPiece currentPiece = null;
	String startingPiece = "";
	
	public StartingSquare(String ID, String startingSquare ) {
		super(ID);
		startingPiece = startingSquare;
	}

	/**
	 * When a player "walks in"
	 */
	public void enterPlayer(Player enterPlayer) {
		currentPiece  = enterPlayer;
	}

	/**
	 * When a player "walks out"
	 */
	public void leavePlayer() {
		currentPiece = null;
	}
	

	public boolean isOccupied() {
		return (currentPiece != null);
	}
	
	public void setPiece(BoardPiece piece) {
		currentPiece = piece; 
	}
	
	public Vector getPresent() {
		Vector ret = new Vector();
		ret.add(currentPiece);
		return ret;

	}
	
	/**
	 * @return Returns the startingPiece.
	 */
	public String getStartingPiece() {
		return startingPiece;
	}
	/**
	 * @param startingPiece The startingPiece to set.
	 */
	public void setStartingPiece(String startingPiece) {
		this.startingPiece = startingPiece;
	}
}
