package Cluedo.Game;
import java.util.Vector;

/**
 * Represents a Square or Tile in the Cluedo Board, only one person may occupy
 * a square at any given point in time.
 *  
 * @author Alex

 */
public class Square extends Position {
	BoardPiece currentPiece = null;
	
	public Square(String ID ) {
		super(ID);
	}
	
	/**
	 * When a player "walks in"
	 */
	public void enterPlayer(Player enterPlayer) {
		currentPiece  = enterPlayer;
	}

	/**
	 * When a player "walks out"
	 */
	public void leavePlayer() {
		currentPiece = null;
	}
	
	public boolean isOccupied() {
		return (currentPiece != null);
	}
	
	public void setPiece(BoardPiece piece) {
		currentPiece = piece; 
	}
	
	public Vector getPresent() {
		Vector ret = new Vector();
		ret.add(currentPiece);
		return ret;

	}
	
}
