package Cluedo.Game;
import java.util.Vector;


public class Room extends Position {
	Vector presentPieces = new Vector();
	
	/**
	 * Add a player to the room
	 * 
	 * @param who
	 */
	public void addPiece(BoardPiece who) {
	  	presentPieces.add(who);
	}
	public boolean isOccupied() {
		return occupied();
	}
	/**
	 * Find out if players are present
	 * 
	 * @return true if players present, otherwise false
	 * 
	 */
	public boolean occupied() {
		for(int i = 0; i < presentPieces.size(); i++)
			if(presentPieces.elementAt(i) instanceof Player)
				return true;

		return false;
	}
	
	public Room(String ID ) {
		super(ID);

	}
	/**
	 * When a player "walks in"
	 */
	public void enterPlayer(Player enterPlayer) {
		if(presentPieces.contains(enterPlayer) == false)
			presentPieces.add(enterPlayer);
	}
	/**
	 * When a player "walks out"
	 */
	public void leavePlayer(Player enterPlayer) {
		presentPieces.remove(enterPlayer);
	}
	
	public Vector getPresent() {
		return presentPieces;		
	}

	public void addWeapon(BoardPiece boardPiece) {
		presentPieces.add(boardPiece);
	}
	public void addPlayer(BoardPiece boardPiece) {
		presentPieces.add(boardPiece);
	}
	
	public void removeWeapon(BoardPiece boardPiece) {
		presentPieces.remove(boardPiece);
	}
	public void removePlayer(BoardPiece boardPiece) {
		presentPieces.remove(boardPiece);
	}
	
}
