package Cluedo.Game;

/**
 * The player's board piece on the board.
 * @author alex
 */
public class Player
		extends BoardPiece
			implements Cluedo.API.Persistant {
	
	private Board lnkBoard;
	private Position position = new Position("");
	private boolean suggestionOnLastTurn = false;

	private boolean rolled = false;
	private boolean moved = false;
	
	/**
	 * Comment for <code>realName</code><br>
	 * The real name or nickname chosen by the user playing this piece.
	 */
	private String realName = "";
	/**
	 * Comment for <code>playerType</code><br>
	 * What type of player is this?<br>
	 * - 0 human player<br>
	 * - 1 AI player<br>
	 * - 2 Advanced AI player<br>
	 * 
	 */
	private int playerType = -1;
	private CardCollection cardBag = null;
	private DetectivePad detectivePad = null;
	
	/**
	 * Comment for <code>interactive</code><br>
	 * Whether this player still in the game, set to false if a false accusation was made.
	 */
	private boolean interactive = false;
	
	/**
	 * Comment for <code>movesRemaining</code><br>
	 * An integer containing the amount of moves remaining (in squares) on the board.
	 */
	private int movesRemaining = -1;
	
	public Player() {
		realName = "";
		pieceName = "";
		playerType = 0;
		movesRemaining = 0;
		cardBag = new CardCollection();
		detectivePad = new DetectivePad();
		interactive = true;
	}
	
	public int getPlayerType() {
		return playerType;
	}

	
	public void setCards(CardCollection cards){
		cardBag = cards;
	}
	
	public CardCollection getCards() {
		return cardBag;
	}
	public void setPosition(Position newPosition) {
		position = newPosition;
		setMovesRemaining(0);
	}
	public Position getPosition() {
		return position;
	}

	public boolean hasCard(Card card) {
		return cardBag.containsCard(card);
	}
	public Card getCardByName(String card) {
		return cardBag.cardByName(card);
	}
	public boolean giveCard(Card card) {
		return cardBag.insertCard(card);
	}

	public void clearCards() {
		cardBag.resetCards();
	}
	public void setName(String name) {
		realName = name;
	}
	public void setCharacter(String character) {
		pieceName = character;
	}
	
	public void setMovesRemaining(int newMoves) {
		movesRemaining = newMoves;
	}
	public void setInteractive(boolean status) {
		interactive = status;
	}
	public boolean isInteractive() {
		return interactive;
	}
	
	public String getRealName() {
		return realName;
	}
	
	public String getCharacter() {
		return pieceName;
	}


	public int getMovesRemaining() {
		return movesRemaining;
	}
	
	/**
	 * toXML returns all the necessary variables for a save-game
	 * these are pre-named and formatted.
	 * 
	 * @author Alex
	 */
	public String toXML() {
		String output = "";
		
		output = "<player>\n" +
		         "  <name>" +
		         getRealName() +	
        		 "</name>\n" +
		         "  <character>" +
		         getCharacter()+	
        		 "</character>\n" +
		         "  <playertype>" +
		         playerType+	
        		 "</playertype>\n" +
		         "  <position>" +
		         position.getID() +	
        		 "</position>\n" +
		         "  <moved>" +
		         moved +	
        		 "</moved>\n" +
		         "  <rolled>" +
		         rolled +	
        		 "</rolled>\n" +
		         "  <suggested>" +
		         suggestionOnLastTurn +	
        		 "</suggested>\n" +
		         "  <movesRemaining>" +
		         movesRemaining +	
        		 "</movesRemaining>\n" +
		         "  <interactive>" +
		         isInteractive() +	
        		 "</interactive>\n";
	
		output += cardBag.toXML();

		output += detectivePad.toXML();
		
		output += "</player>\n";				 
		return output;
	}

	/**
	 * When the end turn is called the setRolled is reset.
	 *
	 */
	public void endTurn() {
		setRolled(false);
	}
	
	/**
	 * @return Returns the detectivePad.
	 */
	public DetectivePad getDetectivePad() {
		return detectivePad;
	}
	/**
	 * @param detectivePad The detectivePad to set.
	 */
	public void setDetectivePad(DetectivePad detectivePad) {
		this.detectivePad = detectivePad;
	}
	
	
	public boolean canRoll() {
		boolean result = true;
		if(rolled == true)
			return false;
		return result;
	}
	
	
	/**
	 * Altered in compliance with Cluedo rules, not able to move after a suggestion
	 * 
	 * @updateby Alex 13/01/05  
	 * 
	 * @return
	 */
	public boolean canMove() {
		boolean result = true;
		
		if(hasMoved() == true || isSuggestionOnLastTurn() == true)
				return false;

		return result;
	}

	public boolean canSuggestHere() {
		boolean result = true;
		if(!(getPosition() instanceof Room))
			result = false;
		return result;
	}	
	public boolean canSuggest() {
		boolean result = true;
		
		result = (suggestionOnLastTurn == false);
		
		return result;
	}
	
	public boolean canEndTurn() {
		boolean result = true;
		
		return result;
	}
	
	/**
	 * @return Returns the rolled.
	 */
	public boolean hasRolled() {
		return rolled;
	}
	/**
	 * @param rolled The rolled to set.
	 */
	public void setRolled(boolean rolled) {
		this.rolled = rolled;
	}
	/**
	 * @return Returns the moved.
	 */
	public boolean hasMoved() {
		return moved;
	}
	/**
	 * @param moved The moved to set.
	 */
	public void setMoved(boolean moved) {
		if(getPosition() instanceof Room) {
			setSuggestionOnLastTurn(false);
		}
		this.moved = moved;

	}
	public void resetMovedStatus() {
		this.moved = false;		
	}
	/**
	 * @return Returns the suggestionOnLastTurn.
	 */
	public boolean isSuggestionOnLastTurn() {
		return suggestionOnLastTurn;
	}
	/**
	 * @param suggestionOnLastTurn The suggestionOnLastTurn to set.
	 */
	public void setSuggestionOnLastTurn(boolean suggestionOnLastTurn) {
		this.suggestionOnLastTurn = suggestionOnLastTurn;
	}
	/**
	 * @param playerType The playerType to set.
	 */
	public void setPlayerType(int playerType) {
		this.playerType = playerType;
	}
}
