package Cluedo.Game;
import java.util.Vector;
import Cluedo.Game.Card;

/**
 * The detective pad holds a copy of every card in the game so that the player
 * may at his own discretion mark a suspected item.
 *
 * @author alex
 */
public class DetectivePad
		implements Cluedo.API.Persistant {
	
	private Player lnkPlayer;

	/**
	 * CardColletcion here contains all cards in the detective pad
	 */
	CardCollection cardBag = null;
	
	public DetectivePad() {
		cardBag = new CardCollection();
	}

	/**
	 * Calls the eliminateCard function on the relevant card after asking
	 * the CardCollection for the specfied card.
	 * 
	 * Card = CardCollection.getCardByName(nameofCard);
	 * Card.eliminateCard();
	 * 
	 * @param cardName
	 */
	public void markCard(String cardName) {
	  try {
		  cardBag.markCard(cardName);
	  }
	  catch(Exception error) {
		  System.out.println("Error in markcard");
	  }
	}
	/**
	 * Takes a card's name and returns the object if found.
	 * 
	 * @param cardName
	 * @return the card object, or null
	 */
	public Card hasCard(String cardName) {
		return cardBag.cardByName(cardName);
	}
	/**
	 * Calls the eliminateCard function on the relevant card after asking
	 * the CardCollection for the specfied card.
	 * 
	 * Card = CardCollection.getCardByName(nameofCard);
	 * Card.eliminateCard();
	 * 
	 * @param cardName
	 */
	public void unMarkCard(String cardName) {
		cardBag.cardByName(cardName).eliminateCard(false);
	}

	public void setCardBag(CardCollection bag) {
		cardBag = bag;
	}
	/**
	 * Adds a Vector of cards to the CardCollection, this method may be called at any occasion.
	 * @param newCards
	 */
	public void addItems(Vector newCards) {
		for(int i = 0; i < newCards.size(); i++)
			cardBag.insertCard((Card)newCards.elementAt(i));
	}
	
	public void addItems(CardCollection newCards) {
		for(int i = 0; i < newCards.countCards(); i++)
			cardBag.insertCard(newCards.cardAt(i));
	}	
	/**
	 * Returns a list of all cards and the eliminated status for displaying either in the GUI or for the GameController.
	 *  
	 */
	public CardCollection getCardList() {
		return cardBag;
	}
	
	/**
	 * Marks all cards as not eliminated.
	 * 
	 */
	public void resetCards() {
		for(int i =0;i<cardBag.countCards();i++) {
			cardBag.cardAt(i).setEliminated(false);
		}
	}
	
	public String toXML() {
		String output;
		output = "   <detectivepad>\n" +
				cardBag.toXML() +
				"</detectivepad>\n";

		return output;
	}



}
