package Cluedo.Game;

import java.util.Vector;
/**
 * A collection ADS for cards. Handles functions relating to a collection of cards.
 *  
 * @author alex
 */
public class CardCollection 
		implements Cluedo.API.Persistant {
	
	/**
	 * Internal representation of "cards"
	 * 
	 */
	Vector cards;
	
	/**
	 * Remove all cards from the CardCollection.
	 *
	 */
	public void resetCards() {
		cards.clear();
	}
	

	/**
	 * Count the amount of cards in the CardCollection.
	 * @return amount of cards
	 */
	public int countCards() {
		return cards.size();
	}
	
	/**
	 * Reference a card directly in the CardCollection.
	 * @param cardAt
	 * @return Card selected
	 */
	public Card cardAt(int cardAt) {
		if(countCards() > cardAt)
			return (Card)cards.elementAt(cardAt);
		else
			return null;
	}
	
	public void markCard(String card) {
		cardByName(card).eliminateCard(true);
		
	}
	public void unMarkCard(String card) {
		cardByName(card).eliminateCard(false);	
	}
		
	/**
	 * Adds a card to the end of the CardCollection if the card is not already contained
	 * This is a destructive method which makes a clone of the object passed.
	 *
	 * @param card
	 * @return the success of the operation
	 */
	public boolean insertCard(Card card) {
		return insertCard(card, -1);
	}


	/**
	 * @param card
	 * @param i
	 */
	public boolean insertCard(Card card, int index) {
		
		boolean found = false;

		// Searching to check the card isn't already present.
		for(int i = 0; i < cards.size(); i++) {
			if(((Card) cards.elementAt(i)).getName().equals(card.getName())) {
				found = true;
				break;
			}
		}
		
		// Adding that card if not already found
		if(found == false) {
			Card newCard = new Card(card.getName(), card.getType());
			newCard.setEliminated(card.isEliminated());
			
			if(index == -1)
				cards.add(newCard);
			else
				cards.add(index, newCard);

			return true;
		}

		return false;
		
	}
	
	/**
	 * Removes a card from the collection
	 * 
	 * @param card
	 */
	public void removeCard(Card card) {
		Card pointer = null;
		for(int i = 0; i < cards.size(); i++) {
			pointer = ((Card)cards.elementAt(i));
			if(pointer.getName().equals(card.getName()) &&
					pointer.getType().equals(card.getType())) {
				cards.remove(i);
				break;
			}
		}
	}
	/**
	 * Removes a card from the collection
	 * 
	 * @param card
	 */
	public void removeCard(String name, String type) {
		Card pointer = null;
		for(int i = 0; i < cards.size(); i++) {
			pointer = ((Card)cards.elementAt(i));
			if(pointer.getName().equals(name) &&
					pointer.getType().equals(type)) {
				cards.remove(i);
				break;
			}
		}
	}
	
	/**
	 * Searches the CardCollection for a card with the matching name as the
	 * given argument.
	 * 
	 * @param card's name
	 * @return null if card not found or the card if it was found
	 */
	public Card cardByName(String card) {
		for(int i =0; i < cards.size(); i++)
			if(((Card)cards.elementAt(i)).getName().equals(card)) {
					return ((Card)cards.elementAt(i));
			}

		return null;
	}

	public Card cardIncluded(Card card) {
		for(int i =0; i < cards.size(); i++)
			if(((Card)cards.elementAt(i)).getName().equals(card.getName())) {
					return ((Card)cards.elementAt(i));
			}

		return null;
	}
	
	/**
	 * Is a card contained within the CardCollection?
	 * 
	 */
	public boolean containsCard(Card card) {
		boolean result = false;
		if(card == null)  {
			System.out.println("[CardCollection:containsCard] null card passed");
			return false;
		}
		for(int i =0; i < cards.size(); i++)
			if(((Card)cards.elementAt(i)).getName().equals(card.getName())) {
					result = true;
					break;
			}
			
		return result;
	}
	
	/**
	 * On creation of a CardCollection it is empty of cards.
	 *
	 */
	public CardCollection() {
		cards = new Vector();
	}
	
	public Vector getCards() {
		return cards;		
	}
	
	/**
	 * toXML returns all the necessary variables for a save-game
	 * these are pre-named and formatted.
	 * 
	 * @author Alex
	 */
	public String toXML() {
		StringBuffer output = new StringBuffer();
		if(countCards() > 0) {
			output.append("  <cards>\n");
			for(int i = 0; i < countCards(); i++)
				output.append(cardAt(i).toXML()); 
			output.append("  </cards>\n");
		}
		return output.toString();
	}


	/**
	 * 
	 */
	public Vector getUneliminatedCards() {
		Vector pointers = new Vector ();
		for(int i=0;i<countCards();i++) {
			if(cardAt(i).isEliminated() == false) {
				pointers.add(cardAt(i));
			}
		}

		return pointers;
	}
	public Vector getEliminatedCards() {
		Vector pointers = new Vector ();
		for(int i=0;i<countCards();i++) {
			if(cardAt(i).isEliminated() == true) {
				pointers.add(cardAt(i));
			}
		}

		return pointers;
	}


}
