package Cluedo.Game;

/**
 * Could be of type weapon/character/room and is held in a CardCollection.
 * @author alex
 */
public class Card
		implements Cluedo.API.Persistant {

	/**
	 * @param eliminated The eliminated to set.
	 */
	public void setEliminated(boolean eliminated) {
		this.eliminated = eliminated;
	}
	/**
	 * @param name The name to set.
	 */
	public void setName(String name) {
		this.name = name;
	}
	/**
	 * @param type The type to set.
	 */
	public void setType(String type) {
		this.type = type;
	}
	private CardCollection lnkCardBag;

	private String name;
	private String type;
	private boolean eliminated;
	
	/**
	 * Any <code>Card</code> in the card, by default eliminated is set to false.
	 * 
	 * @param newName
	 * @param newType
	 */
	public Card(String newName, String newType) {
		name = newName;
		type = newType;
		eliminated = false;
	}
	public Card() {
		eliminated = false;
	}
	/**
	 * Set the card's status to eliminated or not eliminated.
	 *
	 */
	public void eliminateCard(boolean result) {
			eliminated = result;
	}
	
	public boolean isEliminated() {
		return eliminated;
	}
	public String getType() {
		return type;
	}

	public String getName() {
		return name;
	}
	
	public String toXML() {
		String output = "";
			output += "    <card>\n" +
			          "      <name>" + getName() + "</name>\n" + 
			          "      <type>" + getType() + "</type>\n" +
			          "      <eliminated>" + isEliminated() + "</eliminated>\n" +
          			  "    </card>\n";
		return output;
	}
}