package Cluedo.GUI2;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

import Cluedo.API.CDialog;
import Cluedo.API.CardImage;
import Cluedo.API.LanguagePack;
import Cluedo.Game.Player;

public class WinnerDialog extends CDialog implements ActionListener {

	JFrame parent;
	private static String DEFAULT_GROUP = "win_game";

	public WinnerDialog(JFrame parent, Player who) {
		super("Winner!!!", true);
		setParent((Frame)parent);
		JPanel top = new JPanel();
		
		CardImage winner = new CardImage("./Resources/winner.jpg", "Winner!");
		//(Player)parameters.firstElement()
		top.setLayout(new BorderLayout());
		top.add(winner, BorderLayout.CENTER);
		top.add(new JLabel(
				addArguments(LanguagePack.getString("winner_message_detail", DEFAULT_GROUP), new String[] {who.getRealName()})		
		), BorderLayout.SOUTH);

		JButton doneButton = new JButton("Done");
		doneButton.addActionListener(this);
		
		getContentPane().add(top, BorderLayout.NORTH);
		getContentPane().add(doneButton, BorderLayout.SOUTH);
		pack();
		centre();
		setVisible(true);
	
	}

	public void actionPerformed(ActionEvent e) {
		setVisible(false);

		dispose();
	}

	public void centre() {
    		Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
    		Dimension frameSize = getSize();
    		frameSize.height = ((frameSize.height > screenSize.height) ? screenSize.height : frameSize.height);
    		frameSize.width = ((frameSize.width > screenSize.width) ? screenSize.width : frameSize.width);
    		setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
	}

	/**
	 * Adds relevant arguments to string from String array 
	 * 
	 * @param string
	 * @param names2
	 * @return
	 */
	private static String addArguments(String string, String[] names2) {
		for(int i=0;i<names2.length;i++)
			string = string.replaceAll("%"+(i+1), names2[i]);
		if(string.indexOf("@@") > -1) {
			string = addBreaks(string);
		}
		return string;
	}
	
	
	/**
	 * @param string
	 * @return
	 */
	private static String addBreaks(String string) {
		string = string.replaceAll("@@", "<br>");
		string = Cluedo.API.Constants.HTML_ON + string + Cluedo.API.Constants.HTML_OFF;
		return string;
	}
}
