package Cluedo.GUI2;

import java.awt.BorderLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;

import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.SwingConstants;

import Cluedo.API.CDialog;
import Cluedo.API.CardImage;
import Cluedo.API.LanguagePack;
import Cluedo.Controller.GameController;

public class SuggestionPreview extends CDialog implements ActionListener {
	
	JButton suggest = null;
	JButton cancel = null;
	
	CardImage[] candidateCards = new CardImage[3];
	
	String [] names = new String[3];
	String playerName = "";
	
	GameController gameController = null;
	private static String DEFAULT_GROUP = "suggest_window";
	
	public void actionPerformed(ActionEvent e) {
		
		if (e.getSource().equals(suggest))
			this.setInterestingData(new String("yes"));
		
		else if (e.getSource().equals(cancel))
			this.setInterestingData(new String("no"));
		
		dispose();
	}
	
	public SuggestionPreview(JFrame parent,Vector parameters, GameController gameController) {
		super("Suggest Confirmation",true);
		
		this.gameController = gameController;
		playerName = gameController.board.getCurrentPlayer().getRealName();
		
		for (int i = 0; i<parameters.size(); i++){
			names[i] = (String) parameters.elementAt(i);
			
		}
		
		for(int i = 0; i < names.length; i++) {
			if(new java.io.File("./Resources/Cards/" + names[i].toLowerCase() + ".gif").exists() == true)
				candidateCards[i] = new CardImage("./Resources/Cards/" + names[i].toLowerCase() + ".gif", names[i]);
			else
				candidateCards[i] = new CardImage(names[i].toLowerCase(), names[i]);
		}
		
		suggest = new JButton(
				LanguagePack.getString("suggest_button", DEFAULT_GROUP));
		suggest.addActionListener(this);
		cancel = new JButton(
				LanguagePack.getString("cancel_button", "toolbar"));
		cancel.addActionListener(this);
		
		
		JPanel topPage = new JPanel();
		topPage.setLayout( new BorderLayout() );
		
		
		Box candidateCardsColumn = Box.createHorizontalBox();
		
		JPanel cardRowPanel = new JPanel();
		GridLayout newGridLayout = new GridLayout();
		newGridLayout.setHgap(10);
		cardRowPanel.setLayout( newGridLayout );
		
		
		for(int i = 0; i < names.length; i++) {
			cardRowPanel.add( candidateCards[i] );
			candidateCards[i].setBorder( BorderFactory.createEtchedBorder() );
			
		}		
		candidateCardsColumn.add( cardRowPanel );
		
		//Title
		Box headerPage = Box.createHorizontalBox();
		
		JLabel suggestPreviewLabel = new JLabel();
		suggestPreviewLabel.setText(
				addArguments(LanguagePack.getString("suggest_statement", DEFAULT_GROUP), names));
		
		suggestPreviewLabel.setFont( new Font( "Arial", Font.BOLD, 15) );
		
		
		
		headerPage.add(Box.createVerticalStrut(60));
		headerPage.add(Box.createHorizontalStrut(20));
		headerPage.add(suggestPreviewLabel );
		
		Box header = Box.createVerticalBox();
		header.add(headerPage);
		header.add(new JSeparator(SwingConstants.HORIZONTAL) );
		header.add( Box.createVerticalStrut(10) );
		
		//suggested cards
		Box cardViewPage = Box.createHorizontalBox();
		cardViewPage.add( Box.createHorizontalStrut(30) );
		cardViewPage.add( candidateCardsColumn );
		cardViewPage.add( Box.createHorizontalStrut(30) );
		
		//confirm label
		
		Box confirm = Box.createHorizontalBox();
		
		JLabel confirmLabel = new JLabel(
				addArguments(LanguagePack.getString("suggest_confirm", DEFAULT_GROUP), new String[] {playerName}));
		
		confirmLabel.setFont( new Font( "Arial", Font.BOLD, 15) );
		confirm.add( Box.createVerticalStrut(40) );
		confirm.add( Box.createHorizontalStrut(10) );
		confirm.add( confirmLabel);
		confirm.add( Box.createHorizontalStrut(10) );
		
		//buttons --> suggest and cancel
		Box bottomPage = Box.createHorizontalBox();
		bottomPage.add( Box.createVerticalStrut(10) );	
		bottomPage.add( suggest );
		bottomPage.add( Box.createVerticalStrut(10) );	
		bottomPage.add( cancel );
		bottomPage.add( Box.createVerticalStrut(30) );	
		
		
		topPage.add(header, BorderLayout.NORTH);
		topPage.add(confirm, BorderLayout.SOUTH);
		topPage.add(cardViewPage, BorderLayout.CENTER);
		
		getContentPane().add(topPage, BorderLayout.NORTH);
		getContentPane().add(bottomPage, BorderLayout.SOUTH);
		
		pack();
		centre();
		
	}

	
	public void selectedEvent() {
		for(int i = 0; i < candidateCards.length; i++)
			candidateCards[i].setEnabled(false);
	}
	
	synchronized public void decay() {
		System.out.println("[DisproofWindow:decay] Called");		
		try {
			Thread.sleep(2000);	
		}
		catch(Exception e ) {
			System.out.println("Can't get no sleep");
		}
		
		System.out.println("[DisproofWindow:decay] Done");
		
		dispose();
	}
	
	
	/**
	 * Adds relevant arguments to string from String array 
	 * 
	 * @param string
	 * @param names2
	 * @return
	 */
	private static String addArguments(String string, String[] names2) {
		for(int i=0;i<names2.length;i++)
			string = string.replaceAll("%"+(i+1), names2[i]);
		if(string.indexOf("@@") > -1) {
			string = addBreaks(string);
		}
		return string;
	}
	
	
	/**
	 * @param string
	 * @return
	 */
	private static String addBreaks(String string) {
		string = string.replaceAll("@@", "<br>");
		string = Cluedo.API.Constants.HTML_ON + string + Cluedo.API.Constants.HTML_OFF;
		return string;
	}
}
