package Cluedo.GUI2;

import java.awt.BorderLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

import Cluedo.API.CDialog;
import Cluedo.API.LanguagePack;
import Cluedo.Controller.GameController;

public class SuggestReminder extends CDialog implements ActionListener {
	
	JButton endGo = null;
	JButton suggest = null;

	String playerName = "";
	String playerPos = "";
	
	GameController gameController = null;
	
	private static String DEFAULT_GROUP = "toolbar";
	
	public void actionPerformed(ActionEvent e) {
		
		if (e.getSource().equals(endGo)){
			this.setInterestingData(new String("endGo"));
			
		}
		else if (e.getSource().equals(suggest)){
			this.setInterestingData(new String("suggest"));
		}
		
		dispose();
	}
	
	
	
	public SuggestReminder(JFrame parent, GameController gameController){
		super("End Turn ?", true);
		
		this.gameController = gameController;
		playerName = gameController.board.getCurrentPlayer().getRealName();
		playerPos = gameController.board.getCurrentPlayer().getPosition().getID();
		
		
		
		endGo = new JButton(
				LanguagePack.getString("end_turn", DEFAULT_GROUP));
		endGo.addActionListener(this);
		
		suggest = new JButton(
				LanguagePack.getString("suggest_button", DEFAULT_GROUP));
		suggest.addActionListener(this);
		
		
		JPanel topPage = new JPanel();
		topPage.setLayout( new BorderLayout() );
		
		
		
		Box headerPage = Box.createVerticalBox();
		
		JLabel confirmLabel = new JLabel(
				addArguments(LanguagePack.getString("end_turn_confirm", DEFAULT_GROUP), new String[] {playerName}));
		JLabel suggestInfo = new JLabel(
				addArguments(LanguagePack.getString("end_turn_status", DEFAULT_GROUP), new String[] {playerPos}));
		
		confirmLabel.setFont( new Font( "Arial", Font.BOLD, 14) );
		suggestInfo.setFont( new Font( "Arial", Font.BOLD, 17) );
		
		headerPage.add( Box.createHorizontalStrut(30) );
		headerPage.add( suggestInfo );
		headerPage.add( Box.createVerticalStrut(10) );
		headerPage.add( confirmLabel );
		headerPage.add( Box.createVerticalStrut(10) );
		
		Box bottom  = Box.createHorizontalBox();
		bottom.add(Box.createHorizontalStrut(90));
		bottom.add(endGo);
		bottom.add(Box.createHorizontalStrut(20));
		bottom.add(suggest);
		bottom.add(Box.createHorizontalStrut(90));
		bottom.add(Box.createVerticalStrut(40));
		
		getContentPane().add(headerPage, BorderLayout.NORTH);
		getContentPane().add(bottom, BorderLayout.CENTER);
		
		pack();
		centre();
	}
	
	
	
	
	/**
	 * Adds relevant arguments to string from String array 
	 * 
	 * @param string
	 * @param names2
	 * @return
	 */
	private static String addArguments(String string, String[] names2) {
		for(int i=0;i<names2.length;i++)
			string = string.replaceAll("%"+(i+1), names2[i]);
		if(string.indexOf("@@") > -1) {
			string = addBreaks(string);
		}
		return string;
	}
	
	
	/**
	 * @param string
	 * @return
	 */
	private static String addBreaks(String string) {
		string = string.replaceAll("@@", "<br>");
		string = Cluedo.API.Constants.HTML_ON + string + Cluedo.API.Constants.HTML_OFF;
		return string;
	}
}
