/*
 * Created on Mar 15, 2005
 */
package Cluedo.GUI2;

import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Properties;

import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;

import Cluedo.API.CDialog;

/**
 * @author Alex
 */
public class Options extends CDialog implements ActionListener {
    JCheckBox soundStatus = new JCheckBox ("Enable sound");
    JCheckBox lookFeelStatus = new JCheckBox ("Enable look and feel (requires restart)");
    
    Properties set = new Properties();
    
    
    public Options() {
        super("Options", true);
        JButton done = new JButton("Done");
        JButton cancel = new JButton("Cancel");
        
        done.addActionListener(this);
        cancel.addActionListener(this);
        
        done.setActionCommand("done");
        cancel.setActionCommand("cancel");
        
        getContentPane().setLayout(new GridLayout(0,1));
        
        getContentPane().add(new JLabel("Options for the game"));
        getContentPane().add(soundStatus);
        getContentPane().add(lookFeelStatus);
        
        create(new JButton[]{done,cancel});
        try {
            set.load(new FileInputStream("Resources/Config/game.config"));
        }
        catch(Exception e) {}
        
        if(set.getProperty("sound").equals("true")) {
        	soundStatus.setSelected(true);
        }
        if(set.getProperty("decoration").equals("true")) {
            lookFeelStatus.setSelected(true);
        }
        	
        centre();
    }

	/**
	 * Centre the frame on the screen.
	 *
	 */
	public void centre() {
        	Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        	Dimension frameSize = getSize();
        	frameSize.height = ((frameSize.height > screenSize.height) ? screenSize.height : frameSize.height);
        	frameSize.width = ((frameSize.width > screenSize.width) ? screenSize.width : frameSize.width);
        	setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
	}

    public void actionPerformed(ActionEvent e) {
        if(e.getActionCommand().equals("done")) {
            try {
                set.setProperty("decoration", ""+lookFeelStatus.isSelected());
                set.setProperty("sound", ""+soundStatus.isSelected());
                
                set.store(new FileOutputStream("Resources/game.config"), "");
            }
            catch(Exception exp) {
                
            }

        }
        dispose();        
    }
}
