package Cluedo.GUI2;

import Cluedo.API.CluedoConfig;
import Cluedo.Controller.GameController;
import Cluedo.Game.Player;


public class AdvanceLoader {
  
  public static void main(String args[]) {

	Cluedo.API.Resources.configureUI();

	GameController gameController = new GameController();      
	CluedoConfig cluedoConfig = new CluedoConfig();


	String names[] = new String[] { "Alex", "Daniel", "Andrew" };
	String chars[] = new String[] { "ColonelMustard", "ReverendGreen", "MrsWhite" };

	for(int i = 0; i < 3; i++) {
		Player player = new Player();
		player.setName(names[i]);
		player.setCharacter(chars[i]);
		cluedoConfig.addPlayer(player);
	}
	
			
	// Load map areas
			
	AdvanceGUI advance = null;
	
	if(args.length >= 1) {
		cluedoConfig.setCardSet(args[0]);
		System.out.println("[AdvanceGUI:Loader] using map: " + args[0]);
		cluedoConfig.setMapVersion(args[0]);
	}
	else
		System.out.println("[AdvanceGUI:Loader] using map: " + "default");
	cluedoConfig.loadMapArea();
		
	advance = new AdvanceGUI("AdvanceGUI GUI 0.1", cluedoConfig, gameController, false, true);

	advance.setVisible(true);


  }       

  
}