package Cluedo.GUI2;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;

import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.SwingConstants;

import Cluedo.API.CDialog;
import Cluedo.API.CardImage;
import Cluedo.API.LanguagePack;
import Cluedo.API.SoundEngine;
import Cluedo.Controller.GameController;

public class AccuseNotification extends CDialog implements ActionListener {


	CardImage[] candidateCards = new CardImage[3];
	
	String [] names = new String[3];
	String playerName = "";
	
	GameController gameController = null;
	
	private static String DEFAULT_GROUP = "win_game";
	
	public void actionPerformed(ActionEvent e) {
		dispose();
	}

	public AccuseNotification (JFrame parent, Vector winningCards, GameController gameController) {
		super("Winner !",true);
		
		this.gameController = gameController;
		playerName = gameController.board.getCurrentPlayer().getRealName();
		
		for (int i = 0; i<winningCards.size(); i++){
			names[i] = (String) winningCards.elementAt(i);
			
		}
		
		for(int i = 0; i < names.length; i++) {
			if(new java.io.File("./Resources/Cards/" + names[i].toLowerCase() + ".gif").exists() == true)
				candidateCards[i] = new CardImage("./Resources/Cards/" + names[i].toLowerCase() + ".gif", names[i]);
			else
				candidateCards[i] = new CardImage(names[i].toLowerCase(), names[i]);
		}
		
		
		
		
		JPanel topPage = new JPanel();
		topPage.setLayout( new BorderLayout() );
		
		Box headerPage = Box.createVerticalBox();

		Box cardViewPage = Box.createHorizontalBox();
		Box bottomPage = Box.createHorizontalBox();
		
		
		Box candidateCardsColumn = Box.createHorizontalBox();
		
		JPanel cardRowPanel = new JPanel();
		GridLayout newGridLayout = new GridLayout();
		newGridLayout.setHgap(10);
		cardRowPanel.setLayout( newGridLayout );

		

		for(int i = 0; i < names.length; i++) {
			cardRowPanel.add( candidateCards[i] );
			candidateCards[i].setBorder( BorderFactory.createEtchedBorder() );

		}		
		candidateCardsColumn.add( cardRowPanel );

		

		
		JLabel titleLabel = new JLabel(
				addArguments(LanguagePack.getString("winner_message", DEFAULT_GROUP), new String[] {playerName}));

		titleLabel.setFont( new Font( "Arial", Font.BOLD, 17) );
		headerPage.add( Box.createHorizontalStrut(20) );
		headerPage.add( titleLabel );
		headerPage.add( Box.createVerticalStrut(20) );

		headerPage.add( new JSeparator(SwingConstants.HORIZONTAL) );
		headerPage.add( Box.createVerticalStrut(10) );
		headerPage.add( new JLabel( 
				LanguagePack.getString("winning_cards", DEFAULT_GROUP)));		
		
		cardViewPage.add( Box.createHorizontalStrut(30) );
		cardViewPage.add( candidateCardsColumn );
		cardViewPage.add( Box.createHorizontalStrut(30) );

		
	
		topPage.add(headerPage, BorderLayout.NORTH);
		topPage.add(cardViewPage, BorderLayout.CENTER);

	
		
		getContentPane().add(topPage, BorderLayout.NORTH);
		getContentPane().add(bottomPage, BorderLayout.SOUTH);
		
		pack();
		centre();

	}
	
	public AccuseNotification(JFrame parent, GameController gameController){
		super("Notification",true);
		
		this.gameController = gameController;
		playerName = gameController.board.getCurrentPlayer().getRealName();
		
		
		
		
		
		JPanel topPage = new JPanel();
		topPage.setLayout( new BorderLayout() );
		
		//
		String file = "Resources/loser"+((int)(Math.random() * 3))+".jpg";
		//System.out.println(file);
		JLabel l = new JLabel (new ImageIcon(file));
		Box cardViewPage = Box.createHorizontalBox();
		cardViewPage.add(l);
		//
		
		Box headerPage = Box.createVerticalBox();
		JLabel titleLabel = new JLabel(
				addArguments(LanguagePack.getString("looser_message", DEFAULT_GROUP), new String[] {playerName}));
		titleLabel.setFont( new Font( "Arial", Font.BOLD, 17) );
		headerPage.add( Box.createHorizontalStrut(30) );
		headerPage.add( titleLabel );
		headerPage.add( Box.createVerticalStrut(20) );
		getContentPane().add(headerPage, BorderLayout.NORTH);
		getContentPane().add(cardViewPage, BorderLayout.CENTER);
		
		SoundEngine.bufferSound("loser");
		
		pack();
		centre();
	}
	public void centre() {
    	Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
    	Dimension frameSize = getSize();
    	frameSize.height = ((frameSize.height > screenSize.height) ? screenSize.height : frameSize.height);
    	frameSize.width = ((frameSize.width > screenSize.width) ? screenSize.width : frameSize.width);
    	setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
}

	public void selectedEvent() {
		for(int i = 0; i < candidateCards.length; i++)
			candidateCards[i].setEnabled(false);
	}
		
	
	/**
	 * Adds relevant arguments to string from String array 
	 * 
	 * @param string
	 * @param names2
	 * @return
	 */
	private static String addArguments(String string, String[] names2) {
		for(int i=0;i<names2.length;i++)
			string = string.replaceAll("%"+(i+1), names2[i]);
		if(string.indexOf("@@") > -1) {
			string = addBreaks(string);
		}
		return string;
	}
	
	
	/**
	 * @param string
	 * @return
	 */
	private static String addBreaks(String string) {
		string = string.replaceAll("@@", "<br>");
		string = Cluedo.API.Constants.HTML_ON + string + Cluedo.API.Constants.HTML_OFF;
		return string;
	}

}
