package Cluedo.GUI2;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;

import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.SwingConstants;

import Cluedo.API.CDialog;
import Cluedo.API.CardImage;
import Cluedo.API.LanguagePack;
import Cluedo.Controller.GameController;
import Cluedo.Game.CardCollection;
import Cluedo.Game.Player;

public class AccuseConfirmation extends CDialog implements ActionListener {
	private static final String DEFAULT_GROUP = "toolbar";
	
	JButton accuse = null;
	JButton cancel = null;
	CardImage[] candidateCards = new CardImage[3];
	
	GameController gameController = null;
	
	String [] names = new String[3];
	Vector parameters;
	JFrame parentFrame = null;
	String playerName = "";
	
	public AccuseConfirmation (JFrame parent,Vector parameters, GameController gameController) {
		super("Confirmation", true);
		this.parentFrame = parent;
		this.gameController = gameController;
		playerName = gameController.board.getCurrentPlayer().getRealName();
		this.parameters = parameters;
		for (int i = 0; i<parameters.size(); i++){
			names[i] = (String) parameters.elementAt(i);
			
		}
		
		for(int i = 0; i < names.length; i++) {
			if(new java.io.File("./Resources/Cards/" + names[i].toLowerCase() + ".gif").exists() == true)
				candidateCards[i] = new CardImage("./Resources/Cards/" + names[i].toLowerCase() + ".gif", names[i]);
			else
				candidateCards[i] = new CardImage(names[i].toLowerCase(), names[i]);
		}
		
		accuse = new JButton( LanguagePack.getString("accuse_button", DEFAULT_GROUP) );
		accuse.addActionListener( this );
		cancel = new JButton( LanguagePack.getString("cancel_button", DEFAULT_GROUP) );
		cancel.addActionListener( this );
		
		
		JPanel topPage = new JPanel();
		topPage.setLayout( new BorderLayout() );
		
		Box candidateCardsColumn = Box.createHorizontalBox();
		
		JPanel cardRowPanel = new JPanel();
		GridLayout newGridLayout = new GridLayout();
		newGridLayout.setHgap(10);
		cardRowPanel.setLayout( newGridLayout );
	
		for(int i = 0; i < names.length; i++) {
			cardRowPanel.add( candidateCards[i] );
			candidateCards[i].setBorder( BorderFactory.createEtchedBorder() );
			
		}		
		candidateCardsColumn.add( cardRowPanel );
		
		//title label, with JSeparator
		JLabel suggestPreviewLabel = new JLabel();			
		suggestPreviewLabel.setText(
				addArguments(LanguagePack.getString("accuse_message", DEFAULT_GROUP), names));

		suggestPreviewLabel.setFont( new Font( "Arial", Font.BOLD, 15) );
		Box headerPage = Box.createHorizontalBox();
		headerPage.add( Box.createVerticalStrut(60) );
		headerPage.add( Box.createHorizontalStrut(20) );
		headerPage.add( suggestPreviewLabel );
		
		Box header = Box.createVerticalBox();
		header.add( headerPage );
		header.add( new JSeparator(SwingConstants.HORIZONTAL) );
		header.add( Box.createVerticalStrut(10) );
		
		
		//card image of accusation made
		Box cardViewPage = Box.createHorizontalBox();
		cardViewPage.add( Box.createHorizontalStrut(30) );
		cardViewPage.add( candidateCardsColumn );
		cardViewPage.add( Box.createHorizontalStrut(30) );
		
		//confirmation label.. and consequence of accusation label
		Box confirm = Box.createVerticalBox();
		JLabel confirmLabel = new JLabel(
				addArguments(LanguagePack.getString("accuse_confirm_message", DEFAULT_GROUP),new String[] { playerName }));
		confirmLabel.setFont( new Font( "Arial", Font.BOLD, 15) );
		//System.out.println(LanguagePack.getString("accuse_warning_message", DEFAULT_GROUP));
		JLabel consequenceLabel = new JLabel(
				addBreaks(LanguagePack.getString("accuse_warning_message", DEFAULT_GROUP)));

		consequenceLabel.setFont( new Font( "Arial", Font.BOLD, 12) );
		
		confirm.add( Box.createVerticalStrut(10) );
		confirm.add( confirmLabel );
		confirm.add( Box.createVerticalStrut(5) );
		confirm.add( consequenceLabel );
		Box confirmBox = Box.createHorizontalBox();
		confirmBox.add(Box.createHorizontalStrut(20));
		confirmBox.add(confirm);
		
		//buttons ---> Accuse, Cancel
		Box bottomPage = Box.createHorizontalBox();
		bottomPage.add( Box.createVerticalStrut(30) );	
		bottomPage.add( accuse );
		bottomPage.add( Box.createVerticalStrut(10) );	
		bottomPage.add( cancel );
		bottomPage.add( Box.createVerticalStrut(30) );	
		
		topPage.add(header, BorderLayout.NORTH);
		topPage.add(confirmBox, BorderLayout.SOUTH);
		topPage.add(cardViewPage, BorderLayout.CENTER);
		
		
		getContentPane().add(topPage, BorderLayout.NORTH);
		getContentPane().add(bottomPage, BorderLayout.SOUTH);
		
		pack();
		centre();
	}
	

	public void actionPerformed(ActionEvent e) {
		
		if (e.getSource().equals(accuse)) {
			
			Player currentPlayer = gameController.board.getCurrentPlayer();
			CardCollection DCards = currentPlayer.getDetectivePad()
			.getCardList();
			
			if (gameController.board.getEnvelope().containsCard(
					DCards.cardByName(names[0]))
					&& gameController.board.getEnvelope().containsCard(
							DCards.cardByName(names[1]))
							&& gameController.board.getEnvelope().containsCard(
									DCards.cardByName(names[2]))) {
				
				Vector arguments = new Vector();
				arguments.add(currentPlayer);
				gameController.directCommand("winGame", arguments);
				
				gameController.directCommand("removeInteractive", null);
				
				dispose();
				AccuseNotification ac = new AccuseNotification(parentFrame,
						parameters, gameController);
				ac.show();
				
			} else {
				gameController.directCommand("removeInteractive", null);
				dispose();
				AccuseNotification ac = new AccuseNotification(parentFrame,
						gameController);
				ac.show();
			}
			
		}
		
		else {
			dispose();
		}
		
		dispose();
	}
	
	public void centre() {
		Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
		Dimension frameSize = getSize();
		frameSize.height = ((frameSize.height > screenSize.height) ? screenSize.height : frameSize.height);
		frameSize.width = ((frameSize.width > screenSize.width) ? screenSize.width : frameSize.width);
		setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
	}
	
	synchronized public void decay() {
		System.out.println("[AccuseConfirmation:decay] Called");		
		try {
			Thread.sleep(2000);	
		}
		catch(Exception e ) {
			System.out.println("Can't get no sleep");
		}
		
		System.out.println("[AccuseConfirmation:decay] Done");
		setVisible(false);
		dispose();
	}
	
	
	public void selectedEvent() {
		for(int i = 0; i < candidateCards.length; i++)
			candidateCards[i].setEnabled(false);
	}

	/**
	 * Adds relevant arguments to string from String array 
	 * 
	 * @param string
	 * @param names2
	 * @return
	 */
	private static String addArguments(String string, String[] names2) {
		for(int i=0;i<names2.length;i++)
			string = string.replaceAll("%"+(i+1), names2[i]);
		if(string.indexOf("@@") > -1) {
			string = addBreaks(string);
		}
		return string;
	}


	/**
	 * @param string
	 * @return
	 */
	private static String addBreaks(String string) {
		string = string.replaceAll("@@", "<br>");
		string = Cluedo.API.Constants.HTML_ON + string + Cluedo.API.Constants.HTML_OFF;
		return string;
	}
}
