package Cluedo.GUI;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

import javax.swing.ImageIcon;
import javax.swing.JComponent;

import Cluedo.API.CluedoConfig;
import Cluedo.API.CluedoListener;
import Cluedo.API.Message;
import Cluedo.Controller.GameController;

/**
* Board GUI Component extends JComponent to abstract the notion of the board and image.
*
*/
public class Board extends JComponent implements MouseListener {
	/**
	 * Board graphic as ImageIcon
	 */
	ImageIcon staticBoardImage = null;
	/**
	 * Board graphic as Image
	 */
	Image boardImage = null;
	/**
	 * Dimension of board graphic
	 */
	Dimension dimensions = null;

	int debugLevel = 0;
	boolean detectMouse = false; 
	
	CluedoConfig gameConfig = null;
	GameController gameController = null;
	
	void setUplink(CluedoConfig gameConfig, GameController gameController) {
		this.gameController = gameController;
		this.gameConfig = gameConfig;
		gameController.bindListener(cluedoListener);
	}
	
	/**
	 * CluedoListener acts as an inbox to receive messages from the GameController and will decide
	 * whether it needs to update any information.
	 *
	 */
	CluedoListener cluedoListener = new CluedoListener() {
		
		public void notifyAlert(Message message) {
			if(debugLevel > 1)
				System.out.println("[Board:notifyAlert]  [" + message.type + "] '" + message.data + "'\n");
		}
	};
	
	

	/**
	* Listen for mouse-clicks and then look-up which position was clicked.
	*
	*/
	public void mouseClicked (MouseEvent e) {
		if(detectMouse == true) {
			System.out.println("Click\t\t[X:"+ e.getX() + "] [Y:" + e.getY()+"]\t\t");

		}
	}
	public void mousePressed(MouseEvent e) {
	}
	public void mouseReleased(MouseEvent e) {
	}
	public void mouseEntered(MouseEvent e) {
	}
	public void mouseExited(MouseEvent e) {
	}
	public void mouseDragged(MouseEvent e) {
	}
	public void mouseMoved(MouseEvent e) {	
	} 

	/**
	* Override the paint method in order to perform "custom" actions on updates
	*
	*/
	public void paint( Graphics g ) {
	   
	   // The background image
	   staticBoardImage.paintIcon( this, g, 0, 0 ); 
	}

	/**
	* Pass the name of the image you want to load.
	*
	*/
	public Board( String fileName ) {
		super();
		// Load image as ImageIcon
		staticBoardImage = new ImageIcon((Toolkit.getDefaultToolkit().getImage( this.getClass().getResource(fileName) )));
		
		// Cast to ImageIcon to Image to get some dimensions data from it
		boardImage = staticBoardImage.getImage();

    		dimensions = new Dimension( staticBoardImage.getIconWidth(), staticBoardImage.getIconHeight() );

		// Make the board doesn't grow / shrink
    		setMaximumSize( dimensions ); setMinimumSize( dimensions ); setPreferredSize( dimensions );
    
		// Handle mouse events in this class
		addMouseListener( this );
	}
	
}