/*
 * Created on Feb 26, 2005
 */
package Cluedo;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

public class CustomComboBoxDemo extends JPanel {

	public CustomComboBoxDemo() {

		//Load the pet images
		ImageIcon tick;
		ImageIcon cross;

		String[] petStrings = { "Bird", "Cat", "Dog", "Rabbit", "Pig" };
		cross = new ImageIcon("E:/tick.gif");
		tick = new ImageIcon("E:/tick.gif");

		// Create the combo box
		JComboBox petList = new JComboBox();
		ComboBoxRenderer renderer = new ComboBoxRenderer();
		renderer.setPreferredSize(new Dimension(80, 20));
		petList.setRenderer(renderer);
		petList.setMaximumRowCount(3);

		// Layout the demo
		setLayout(new BorderLayout());
		add(petList, BorderLayout.NORTH);
		setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
	}

	public static void main(String s[]) {
		JFrame frame = new JFrame("CustomComboBoxDemo");
		frame.addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent e) {
				System.exit(0);
			}
		});

		frame.getContentPane().add(new CustomComboBoxDemo(),
				BorderLayout.CENTER);
		frame.pack();
		frame.setVisible(true);
	}

	class ComboBoxRenderer extends JLabel implements ListCellRenderer {
		public ComboBoxRenderer() {
			setOpaque(true);
			setHorizontalAlignment(LEFT);
			setVerticalAlignment(CENTER);
		}

		public Component getListCellRendererComponent(JList list, Object value,
				int index, boolean isSelected, boolean cellHasFocus) {
			
			if (isSelected) {
				setBackground(list.getSelectionBackground());
				setForeground(list.getSelectionForeground());
			} else {
				setBackground(list.getBackground());
				setForeground(list.getForeground());
			}

			ImageIcon icon = (ImageIcon) value;
			setText(icon.getDescription());
			setIcon(icon);
			return this;
		}
	}
}