package Cluedo.API;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Vector;

import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

import Cluedo.Game.Card;
import Cluedo.Game.CardCollection;

public class TickedComboBox extends JComboBox {
	ImageIcon tick;
	ImageIcon cross;
	Vector labels;
	CardCollection cards = new CardCollection();
	
	public void setCardCollection(CardCollection cards) {
		this.cards = cards;
	}
	
	public TickedComboBox(Vector vector) {
		super(vector);
		cross = new ImageIcon("/tmp/tick.gif");
		tick = new ImageIcon("/tmp/cross.gif");
		this.labels = vector;

		// Create the combo box
		ComboBoxRenderer renderer = new ComboBoxRenderer();
		renderer.setPreferredSize(new Dimension(80, 20));
	//	setRenderer(renderer);
		setMaximumRowCount(labels.size());
	}



	class ComboBoxRenderer extends JLabel implements ListCellRenderer {
		public ComboBoxRenderer() {
			setOpaque(true);
			setHorizontalAlignment(LEFT);
			setVerticalAlignment(CENTER);
			setBackground(Color.red);
		}

		public Component getListCellRendererComponent(JList list, Object value,
				int index, boolean isSelected, boolean cellHasFocus) {
			String cardName = value.toString();
			Card card = cards.cardByName(cardName);
			
			System.out.println(cardName + " focus " + cellHasFocus );
			if(cards != null && index > -1) {

			boolean eliminated = card.isEliminated() == true;

			if(isSelected == true)
				setSelectedIndex(index);
			
			
			if(eliminated == true)
				setBackground(Color.gray);
			else
				setBackground(Color.red);

			if(!(cards== null || index == -1)) {
				System.out.println("index: " + index + " eliminated="+eliminated);



				if(eliminated == true) {
					//setIcon(tick);
					setText("<html><body><strike>"+(String)labels.elementAt(index)+"</strike></html>");
				}
				else {
					//setIcon(cross);
					setText("<html><body>"+(String)labels.elementAt(index)+"</strike></html>");
				}

			}
			}

			return this;
		}
	}



}
