/*
 * Created on Dec 12, 2004
 */
package Cluedo.API;

/**
 * Contains functions to help with parsing and outputting text.
 *  
 *  
 * @author Alex
 */
public class StringFuncs {

	/**
 	  * Used to check characters are within valid range, useful for name checking.
 	  * <br>
 	  * Range: All letters upper or lower case and numbers 0 - 9.
 	  * <br>
	  * @updatedby	Tofiquer	10/12/2004
	  * @updatedby	Alex		17/12/2004
	  *
	  */
	public static boolean validAlphaNumeric(String name){
		boolean valid = true;

		for (int i=0; i < name.length(); i++) {			
			if (!((name.charAt(i) >= 'a' && name.charAt(i) <= 'z') 
					|| (name.charAt(i)>= 'A' && name.charAt(i) <= 'Z')
					|| (name.charAt(i) >= '0' && name.charAt(i) <= '9'))) {
				valid = false;
				break;
			}
		}
		return valid;
	}
	
	/**
	 * Convert charAt(0) of a string to capitals.
	 * 
	 * @param str
	 * String to transform
	 * @return returns the string with the first letter in capitals.
	 */
	public static String capitalise(String str) {
	    if(str.length() == 0)
	        return str;
		return str.substring(0,1).toUpperCase() + str.substring(1);	    
	}

	
		
	/**
	 * A quick and lazy function to wrap a string around to a certain length, it only
	 * cares about 2 line strings -- this is because there isn't any call for wrapping
	 * on more than 2 lines.
	 * 
	 * @param input
	 * un-wrapped text
	 * @param width
	 * width to wrap to
	 * @return
	 * wrapped string
	 */
	public static String wrapString(String input, int width) {
		String imploded = "";
		
		if(input.length() < width)
			return input;

		// This function will be written another time.

		input.replaceAll("\n", "");

		imploded += input.substring(0, width);
		imploded.replaceAll("\n", "");
		imploded += "\n";
		imploded += input.substring(width, input.length());
		
		return imploded;
	
	}
	
	/**
	 * Used to space out a string and print some text at the end.<p>
	 * <br>
	 * (This example may required a fixed size font such as courier new to be viewed correctly.
	 * <p>
	 * <b>Colonel                     [X]</b><br>
	 * <b>Colonel.....................[X]</b><br>
	 * <b>The Colonel.................[X]</b><br>
	 * 
	 * 
	 * @param start
	 * index to start spacing at
	 * @param spacer
	 * what character to use as a "spacer"
	 * @param end
	 * the data to be printed at the end of the line
	 * @param length
	 * desired length of string
	 * @return
	 * the string in the above format
	 */
	public static String space(String start, String spacer, String end, int length) {
		String result = "";
		result += start;
		while ( result.length() + end.length() < length)
			result += " ";
		result += end;
		
		return result;
	}

  

  public static String implode(String args[]) {
	return implode(args, " ", 0);
  }

  /**
  * Implodes ( or joins ) together an array of strings into a single string
  *
  * @param args
  * The array of string data
  * @param separator
  * How to separate each element
  * @param offset
  * The offset to start in the array, ie skip the first element
  */
  public static String implode(String args[], String separator, int offset) {
  	String output = "";

  	for(int i = offset; i < args.length; i++)
  		if(i == (args.length -1))
  			output += args[i] + "";
  		else
  			output += args[i] + separator;
  	return output;
  }
  	
}
