package Cluedo.API;

import java.util.Vector;

/**
  * A structured Message object to be used for internal communication between
  * classes.
  *
  * @author Alex Ellis
  */
public class Message {

 public String source;
 public String destination;
 public long timestamp;
 public String type;
 public String data;
 public Vector parameters;

  public Message() {
  	source = "";
  	destination = "";
  	timestamp = 0;
  	type = "";
  	data = "";
  	parameters = new Vector();
  }

	
/**
 * @return Returns the data.
 */
public String getData() {
    return data;
}
/**
 * @param data The data to set.
 */
public void setData(String data) {
    this.data = data;
}
/**
 * @return Returns the parameters.
 */
public Vector getParameters() {
    return parameters;
}
/**
 * @param parameters The parameters to set.
 */
public void setParameters(Vector parameters) {
    this.parameters = parameters;
}
/**
 * @return Returns the type.
 */
public String getType() {
    return type;
}
/**
 * @param type The type to set.
 */
public void setType(String type) {
    this.type = type;
}
}
