/*
 * Created on Dec 17, 2004
 */
package Cluedo.API;

import java.awt.geom.*;
import java.awt.*;

import java.util.ArrayList;

/**
 * Class represents a polygon area and once constructed will return whether a co-ordinate
 * belongs to it. This is useful for GUI -> View translations.<P>
 *
 *User clicks  (400,300)<p>
 *
 * mapArea1.hit(X,Y) ?<br>
 * True.. therefore the user clicked on mapArea1<br>
 * False.. the user clicked somewhere else<br>
 * <br>
 * mapArea1.getID() == "Kitchen"<br>
 * The user clicked on the Kitchen, <br>Position wantedPosition = board.gameController.map.findByID("Kitchen");<br>
 *
 *
 * @author Alex
 */
public class MapArea {
	private float[][] points;
	private String ID = "";
	private Shape shape = null;
	
	private ArrayList characterPoints = new ArrayList();


	/**
	 * MapArea config for a translation of GUI area to map node
	 * 
	 * @param ID of node
	 * @param X co-ordinates
	 * @param Y co-ordinates
	 */
	public MapArea(String ID, float points[][]) {
		this.ID = ID;

		this.points = new float[points.length][2];

		for(int i = 0; i < points.length; i++) {
			this.points[i][0] = points[i][0];
			this.points[i][1] = points[i][1];
		}
		
		shape = buildPath();
	}

	
	public void setPiecePoints(ArrayList characterPoints) {
		this.characterPoints = characterPoints;
		
	}

	public ArrayList getPiecePoints() {
		return characterPoints;
	}
		
	public float[][] getPoints() {
		return points;
	}
	
	/**
	 * If a co-ordinate (x,y) belongs to this defined area.
	 * @param x co-ordinate
	 * @param y co-ordinate
	 * @return true if (x,y) was hit, or false
	 *
	 */
	public boolean hit(float x, float y) {
		return shape.contains(x, y);
	}

	/**
	 * Calls functions to build shape's area.
	 */
	private Shape buildPath() {
		return getPath(points);
	}

	public Shape getShape() {
		return shape;
	}
	
	/**
	 * Draws a path in a new shape which matches the points defined for this shape.<p>
	 *
	 * @param float array of x points
	 * @param float array of y points
	 *
	 */
	private GeneralPath getPath(float[][] points) {               
		GeneralPath path = new GeneralPath();

		path.moveTo(points[0][0],points[0][1]);

		for(int i=0; i<points.length; i++) {
		   path.lineTo(points[i][0],points[i][1]);
//		   System.out.println(ID +  " link " + points[i][0] +"," +points[i][1] );

		}

		path.closePath();
		return path;
	}


	/**
	 * @return Returns the ID for this area.
	 */
	public String getID() {
		return ID;
	}
	/**
	 * @param ID for this area
	 */
	public void setID(String id) {
		ID = id;
	}
	
}
