package Cluedo.API;

import java.io.File;
import java.util.Hashtable;

public class LanguagePack {
	/**
	 * Hashtable of entries, containing all groups of messages
	 */
	static Hashtable entries = new Hashtable();

	/**
	 * Default language for the package.
	 * 
	 */
	static String DEFAULT_LANGUAGE = Cluedo.API.Constants.DEFAULT_LANGUAGE;
	//static String DEFAULT_LANGUAGE = "en-gb";


	/**
	 * Load a language pack. 
	 * 
	 * @param language
	 * Language pack, not filename
	 */
	public static void initaliseLanguage(String language) {
		File pack = new File("./Resources/Languages/" + language + ".xml");
		if (pack.exists() == false) {
			pack = new File("./Resources/Languages/" + DEFAULT_LANGUAGE
					+ ".xml");
		}

		LanguagePackReader langReader = new LanguagePackReader();
		entries = langReader.readLanguage(pack);
		System.out.println("Catagories: " + entries.size());
	}

	private static void checkLoad() {
		if (entries.size() == 0)
			initaliseLanguage(DEFAULT_LANGUAGE);
	}
	
	
	/**
	 * Given a function name or group lookup the corresponding text message.
	 * 
	 * @param function
	 *            ie suggestion_button
	 * @param group
	 *            ie toolbar/game_menu
	 * @return the string or the function name if not found
	 */
	public static String getString(String function, String group) {
		checkLoad();

		String found = "";
		Hashtable cgroup = ((Hashtable) entries.get(group));
		if (cgroup != null) {
			LanguageBinding message = (LanguageBinding) cgroup.get(function);
			if (message != null)
				found = message.message;
			else
				found = function;
		}

		return found;
	}

	public static void main(String[] args) {
		initaliseLanguage("en-gb");
		System.out.println("new game: '" + getString("new_game", "game_menu")
				+ "'");
	}
}