package Cluedo.API;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

import javax.swing.ImageIcon;
import javax.swing.JComponent;

/**
 * Provides a card which will display its content only when the mouse
 * hovers over it, it can be connected to a Listener who can detect when
 * the object is clicked.<p>
 * This is used in the Disproof window. 
 * 
 * @author Alex Ellis
 *
 */
public class HiddenCardImage extends JComponent implements MouseListener {
	
	Image image = null;
	ImageIcon imageIcon = null;
	Dimension dimensions = null;
	String name = null;
	
	boolean hidden = true;
	boolean cardChosen = false;
	
	Object listener = null;

	static final Dimension defaultDimensions = new Dimension(84, 133);	
	
	
	public HiddenCardImage(String fileName, Object parentClass, String name) {
	
		try {
			// Load image as ImageIcon
			imageIcon = new ImageIcon(fileName);
			
			// Cast to ImageIcon to Image to get some dimensions data from it
			image = imageIcon.getImage();
			
    			dimensions = new Dimension( imageIcon.getIconWidth(), imageIcon.getIconHeight() );
                	                                                                                                
			// Make the image doesn't grow / shrink
    			setMaximumSize( dimensions ); setMinimumSize( dimensions ); setPreferredSize( dimensions );
    			
			this.name = name;

 			this.addMouseListener( this );
		}
		catch(Exception e) {
			
		}
	}	
	
	public HiddenCardImage(String name ) {
		this.name = name;
		dimensions = new Dimension(84, 133);
 		setMaximumSize( dimensions ); setMinimumSize( dimensions ); setPreferredSize( dimensions );
 		this.addMouseListener( this );

	}
	
	public void mouseClicked(MouseEvent e) {
		if(isEnabled() == true && cardChosen == false) {
			cardChosen = true;
			hidden = false;
 			repaint();
 			updateView();
 		}
	}
	public void mouseEntered(MouseEvent e) {
		if(cardChosen == false && isEnabled() == true) {
			hidden = false;
 			repaint();
 		}
	}
	public void mouseExited(MouseEvent e) {
		if(cardChosen == false && isEnabled() == true) {
			hidden = true;
 			repaint();
 		}
 	}
	public void mousePressed(MouseEvent e) {}
	public void mouseReleased(MouseEvent e) {}
	
	public void setListener(Object listener) {
		this.listener = listener;
	}
	
	private void updateView() {
		if(!name.equals(""))
			((SelectedEventListener)listener).selectedEvent();
	}
 
 	public boolean cardChosen() {
 		return cardChosen;
 	}
 	public void paintComponent( Graphics g ) {
		Graphics g2 = (Graphics2D)g;
		if(hidden == false) {
			if(imageIcon != null) {
				// The background image
				imageIcon.paintIcon( this, g, 0, 0 );
			}
			else {
               	if(name.equals(""))
               		return;

				g2.setColor(Color.white);
				g2.fillRect(0, 0, defaultDimensions.width,defaultDimensions.height);
				
				g2.setColor(Color.black);
				g2.drawRect(0,0,defaultDimensions.width-1,defaultDimensions.height-1);
				
				g2.setFont(new Font("Helvetica", Font.BOLD, 12));
				g2.drawString(name, 5, dimensions.height/2) ;
			}
		}
	}
}