package Cluedo.API;


/**
 * Used to notify the disprove of a suggestion.
 */
public class DisproofAlert {

	public String cardShown = "";
	public String suggestedBy = "";
	public String disprovedBy = "";

	public SuggestionAlert originalSuggestionAlert = null;

	/**
	 * @param cardShown
	 * Card chosen to be shown for disproof
	 * @param originalSuggestionAlert
	 * The alert generated with the info regarding who, what, where for the suggestion.
	 *
	 */
	public DisproofAlert( String cardShown, SuggestionAlert originalSuggestionAlert, String disprovedBy ) {
		this.cardShown = cardShown;
		this.originalSuggestionAlert = originalSuggestionAlert;
		this.disprovedBy = disprovedBy;
	}

	public SuggestionAlert getOriginalSuggestion() {
		return originalSuggestionAlert;
	}
	
	public String getCardShown() {
		return cardShown;
	}
	public String getDisprovedBy() {
		return disprovedBy;
	}
}