package Cluedo.API;

import javax.swing.*;
import java.awt.*;

/**
 * Custom dialog box allows some automation of layout and relation to the parent creator. 
 *   
 * @author Alex
 *
 */
public class CDialog extends JDialog {
	
	Object interestingData = null;
	
	Object parent = null;
	
	protected BorderLayout layout = new BorderLayout();
	
	protected GridLayout buttonLayout = new GridLayout();
	
	public CDialog(String frameTitle, boolean mode) {
		super();
		setTitle(frameTitle);
		setModal(mode);
		//this.parent = parent;
		
		getContentPane().setLayout(layout);
		layout.setVgap(10);
		layout.setHgap(10);
		
	}
	
	public void setParent(Object parent) {
		this.parent = parent;
	}
	
	public void create(JButton[] buttons) {
		create(buttons, -1, -1);
	}
	
	public void create(JButton[] buttons, int width, int height) {
		Container content = new Container();
		content.setLayout(new BorderLayout());
		
		content.add(addButtons(buttons), BorderLayout.CENTER);
		
		getContentPane().add(content, BorderLayout.SOUTH);
		
		if (width == -1 && height == -1)
			pack();
		else
			setSize(width, height);
		
	}
	
	public JPanel addButtons(JButton[] buttons) {
		JPanel buttonPanel = new JPanel();
		buttonLayout = new GridLayout(1, buttons.length);
		//buttonLayout.setHgap( 5 );
		buttonPanel.setLayout(buttonLayout);
		
		for (int i = 0; i < buttons.length; i++) {
			buttons[i].setMaximumSize(buttons[i].getPreferredSize());
			buttonPanel.add(buttons[i]);
		}
		
		return buttonPanel;
		
	}
	
	public void centre() {
		Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
		Dimension frameSize = getSize();
		frameSize.height = ((frameSize.height > screenSize.height) ? screenSize.height
				: frameSize.height);
		frameSize.width = ((frameSize.width > screenSize.width) ? screenSize.width
				: frameSize.width);
		setLocation((screenSize.width - frameSize.width) / 2,
				(screenSize.height - frameSize.height) / 2);
	}
	
	public Object getInterestingData() {
		return interestingData;
	}
	
	public void setInterestingData(Object interestingData) {
		this.interestingData = interestingData;
	}
	
}