package Cluedo.API;

import java.util.Vector;

import Cluedo.Game.Card;
import Cluedo.Game.Position;

/**
 * Contract to which all AIs have to conform to, just implement this interface.
 * 
 * 
 * @author Alex Ellis
 *
 */
public interface AIContract {
	
	public void die();
	
	public void bindAI();
	
	public void handleMessage(Message message);
	
	public void setMyName(String myName);
	
	public void initaliseAI();
	
	boolean shouldAccuse();
	
	public boolean accuseCorrect(Card suspectCard, Card weaponCard, Card roomCard);
	
	public boolean makeAccusation();
	
	public Position findRoom();
	
	String suggest();
	
	public void movePlayer(Position target, Vector path, int amount);
	
	int rollDice() throws Exception;
	
	void moveDefendant(Card suspect);
	
	void takeTurn() throws Exception;
	
	String endGo() throws Exception;
	
}